	PROGRAM rbootstrap
	USE MSIMSL
c**********************************************************************
c
c   FORTRAN program to apply nonlinear vector time series lag selection
c   techniques to given dataset.
c   Also apply tests of nonlinearity to that dataset.
c
c   The parameters are defined in the following manner:
c   nkmx = the maximum number of times series in the multivariate
c   nmx = the maximum number of observations for the time series.
c   npmx = the maximum allowable autoregressive order.  npmx = 5.
c   nqmx = the maximum length of the full-stacking vector.
c   
c   Written: 04/30/04 JLH
c   Subprograms called: genvarn, genbvar, mvlrt, mvkeenan,vech,
c                       oritest
c**********************************************************************
c
	parameter (nkmx = 5,nmx=500,npmx=10,maxwk=71950,in=30,nrep=10)
	implicit double precision (a-h, p-z)
c
      double precision x(nmx,nkmx),univar(nmx)
	double precision kendptaus(nkmx,nkmx,npmx)
	double precision kendtaus(nkmx,nkmx,npmx)
	double precision tauprobs(nkmx,nkmx,npmx)
	double precision ptauprobs(nkmx,nkmx,npmx),rrr(10,5,5)
	double precision r(npmx,nkmx,nkmx),rt(npmx,nkmx,nkmx)
	double precision pt(npmx,nkmx,nkmx)
	double precision wk(maxwk,nkmx+3),z(npmx,nkmx)
      character outfile*50

	integer i,irank,iseed,ldr,ldrsig,nr,j,k,u,v
	real cov(2,2),rr(66,2),rsig(2,2),sum1(5),sumtot(nrep,5)
	
c
c   Create interface for using program:
c
cc      write(*,*) " k,nob?"
      write(*,*) " Name of output file for test results?"
      read(*,*) outfile

      call umach(2,nout)

	open(500,file=outfile)
      nr = 66
	k = 2
	ldrsig = 2
	ldr = 66
	cov(1,1) =1
	cov(1,2)=0
	cov(2,1) = 0
	cov(2,2)=1

	nlag =5
	n = nr
	
      
      write(500,*) "Results for critical values R"
      write(500,*)
      write(500,90) k,nlag
 90   format("Number of series and number of observations:",9X,2I7)
      write(500,*) 'No of replicates ', nrep
	write(500,*) 'results in lags of 5 '
  


	do u=1,nrep

	call chfac(k,cov,2,0.00001,irank,rsig,ldrsig)
	iseed = 123457+123*u
	call rnset(iseed)
	call rnmvn(nr,k,rsig,ldrsig,rr,ldr)

c	write(nout,99) ((rr(i,j),j=1,k),i=1,nr)
c99    format('  multivariate normal ', /,
c     &      (1X,2F8.4))
      do j=1,k
	   do i=1,nr
	      x(i,j)=rr(i,j)
	   enddo
	enddo
c      write(*,*) n,nlag,k,x(1,1),x(1,2)
      
c	write(*,*)
      call compr(n,nlag,k,x,in,rrr,rt)

      do v=1,nlag
	sum1(v) = 0 
         do i=1,k
	      do j=1,k
	         sum1(v)=sum1(v)+rrr(v,i,j)/4   ! 4 for each combination of 1 and 
	      enddo
	   enddo
c	write(*,*) sum1(v),v
	sumtot(u,v) =sum1(v)
	enddo

      write(500,120) (sumtot(u,v),v=1,nlag)
120   format(5F8.4)

	enddo    ! end loop over simulations u

c
	stop
	end 



	subroutine compr(n,nlag,k,x,in,r,rt)
c	Subroutine to compute R_{i,j} at lags 1,...,nlag
	parameter (maxn=500, maxk=5, maxp=10,maxlag=10)
  	implicit double precision (a-h,p-z)
	double precision x(maxn,maxk),r(maxlag,maxk,maxk),sigx(maxk)
	double precision sum1(maxk),xt(maxn),yt(maxn)
	double precision rt(maxlag,maxk,maxk)
c	  Compute mean and standard deviation of each series
	sum1=0.0d0
	sigx=0.0d0
	do i=1,k
	   do j=1,n
	     sum1(i)=sum1(i)+x(j,i)
	     sigx(i)=sigx(i)+x(j,i)**2.
	   enddo
	enddo
	do i=1,k
	   sum1(i)=sum1(i)/dble(n)
	   sigx(i)=((sigx(i)-dble(n)*sum1(i)**2.d0)/dble(n-1))**.5d0
	enddo
c
	do i=1,nlag
	  do j=1,k
	    do l=1,k
	      do m=1,n-i
	        xt(m)=(x(m+i,j)-sum1(j))/sigx(j)
	        yt(m)=(x(m,l)-sum1(l))/sigx(l)
	      enddo
	     call hbivar2(in,n-i,xt,yt,deltai,rho)
	     r(i,j,l)= deltai
	     rt(i,j,l)=rho
	     if (deltai.lt.0.0d0) deltai=0.0d0
	     r(i,j,l)=(1.0-dexp(-2.0*deltai))**.5 
c          write(*,*) r(i,j,l),i,j,l
	    enddo
	  enddo
	enddo
c
	return
	end

	subroutine vwn(n,ndim,k,kdim,rho,sigma,eps)
c**********************************************************************
c
c   FORTRAN subroutine to generate vector white noise with a diagonal
c   covariance matrix with all diagonal elements equal to rho.
c 
c   Input: n = an integer containing the number of observations.
c          ndim = an integer containing the number of rows of x in the
c                 calling routine.
c          k = an integer containing the number of components of the
c              realization.
c          kdim = an integer containing the number of rows of sigma
c                 in the calling routine.
c          rho = a double precision scalar containing the correlation.
c
c   Output: sigma = a double precision square matrix of dimension k
c                   containing the covariance matrix of x.
c           eps = a double precision matrix of dimension n x k containing
c                 the desired realization.
c
c   Subprograms called: (IMSL) DCHFAC, (IMSL) DRNMVN
c
c   Written: 3/3/99 JLH
c
c**********************************************************************
c
	implicit double precision (a-h,p-z)
	integer n, ndim, k, kdim
	double precision rho, eps(ndim,kdim), sigma(kdim,kdim), cons
c
c   Set covariance matrix (sigma):
c
	do i = 1,k
	do j = 1,k
		if(i.eq.j) then
			sigma(i,j) = 1.0d0
		else
			sigma(i,j) = rho
		endif
	enddo
	enddo
c
c   Use IMSL subroutines.
c
c   The subroutine DCHFAC computes an upper triangular factorization
c   of a real symmetric nonnegative definite matrix.  The result is 
c   returned in the matrix sigma.
c
c   The subroutine DRNMVN generates pseudorandom numbers from a 
c   multivariate normal distribution.  The result is returned in the
c   vector eps.
c
	cons = 100.0d0*DMACH(4)
	call DCHFAC(k,sigma,kdim,cons,irank,sigma,kdim)
	call DRNMVN(n,k,sigma,kdim,eps,ndim)
c
	return
	end
	

	subroutine kbivar(n,x,y,xt,yt,rho,f)
	parameter(maxn=500)
  	implicit double precision (a-h,p-z)
	double precision xt(maxn),yt(maxn)
c
	hx=.85*(1.0-rho**2.)**(5./12.)*(1+rho**2./2.)**(-1./6.)
     + *dble(n)**(-1./6.)
	hy=hx
c   ********   For testing
c	hx=.85*dble(n)**(-1./6.) 
c	hy=hx
c   ***********
	f=0.0
	do i=1,n
	   f=f+dtpdf((x-xt(i))/hx)*dtpdf((y-yt(i))/hy) 
	enddo
	f=f/(dble(n)*hx*hy)
c
	return
	end
c
	subroutine kuniv(n,x,xt,f)
	parameter(maxn=500)
  	implicit double precision (a-h,p-z)
	double precision xt(maxn)
c
	hx=.85*dble(n)**(-1./5.) 
	f=0.0
	do i=1,n
	   f=f+dtpdf((x-xt(i))/hx) 
	enddo
	f=f/(dble(n)*hx)
c
	return
	end
c
	double precision function dnorm(x)
	implicit double precision (a-h,p-z)
c
      pi=4.0d0*datan(1.0d0)
c
	dnorm=dexp(-.5d0*(x**2.0d0))
	dnorm=dnorm/dsqrt(2.0d0*pi)
c
	return
	end
c
	double precision function dtpdf(x)
	implicit double precision (a-h,p-z)
	parameter(df=4.0d0)
c
      pi=4.0d0*datan(1.0d0)
c
	dtpdf=(1.0d0+x**2.0d0/df)**(-(df+1.0d0)/2.0d0)
	dtpdf=dtpdf/dsqrt(pi*df)
	dtpdf=dtpdf*DGAMMA((df+1.0d0)/2.0d0)*DGAMR(df/2.0d0)
c
	return
	end
c
	subroutine hbivar2(in,n,xt,yt,h,rho)
	parameter(maxn=500,inmx=30)
  	implicit double precision (a-h,p-z)
	double precision xt(maxn),yt(maxn)
	double precision qx(inmx),qwx(inmx),fx(inmx),fy(inmx) 
	double precision xts(maxn),xlow(2),xupp(2) 
c
	rho=0.0d0
	do i=1,n
	   rho=rho+xt(i)*yt(i)
	enddo
	rho=rho/dble(n) 
c     Find max and min of xt and yt 
	CALL DSVRGN (N, xt, xts)
	xlow(1)=xts(1) 
	xupp(1)=xts(n) 
 	CALL DSVRGN (N, yt, xts)
	xlow(2)=xts(1) 
	xupp(2)=xts(n) 
	ndim=2
      CALL DGQRUL (in,1,0.0d0,0.0d0,0,QXFIX,QX,QWX)
	do i=1,in
         tempx=qx(i)*(xupp(1)-xlow(1)+2.)/2.0+(xupp(1)+xlow(1))/2.0
         tempy=qx(i)*(xupp(2)-xlow(2)+2.)/2.0+(xupp(2)+xlow(2))/2.0
         call kuniv(n,tempx,xt,fx(i))
         call kuniv(n,tempy,yt,fy(i))
	enddo
	h=0.0d0
	do i=1,in
	   do j=1,in
         tempx=qx(i)*(xupp(1)-xlow(1)+2.)/2.0+(xupp(1)+xlow(1))/2.0
         tempy=qx(j)*(xupp(2)-xlow(2)+2.)/2.0+(xupp(2)+xlow(2))/2.0
         call kbivar(n,tempx,tempy,xt,yt,rho,f)
         h=h+(dlog(f)-dlog(fx(i))-dlog(fy(j)))*f*qwx(i)*qwx(j)
	   enddo
	enddo
	h=h*(xupp(1)-xlow(1)+2.)*(xupp(2)-xlow(2)+2.)/4.d0
c	
      return
	end    	  
		